<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Trusthub\V1;

use Twilio\Exceptions\TwilioException;
use Twilio\InstanceContext;
use Twilio\Values;
use Twilio\Version;

class PoliciesContext extends InstanceContext {
    /**
     * Initialize the PoliciesContext
     *
     * @param Version $version Version that contains the resource
     * @param string $sid The unique string that identifies the Policy resource
     */
    public function __construct(Version $version, $sid) {
        parent::__construct($version);

        // Path Solution
        $this->solution = ['sid' => $sid, ];

        $this->uri = '/Policies/' . \rawurlencode($sid) . '';
    }

    /**
     * Fetch the PoliciesInstance
     *
     * @return PoliciesInstance Fetched PoliciesInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetch(): PoliciesInstance {
        $payload = $this->version->fetch('GET', $this->uri);

        return new PoliciesInstance($this->version, $payload, $this->solution['sid']);
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $context = [];
        foreach ($this->solution as $key => $value) {
            $context[] = "$key=$value";
        }
        return '[Twilio.Trusthub.V1.PoliciesContext ' . \implode(' ', $context) . ']';
    }
}